
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// generate matrix cyclic group

int main (int argc, char * const argv[])
{
    double      p;
    int         i, m, len, order;
    string      inString;
    char        *xString;
    matq        x; // holds seed matrix of dimension m
    matq        *z; // holds matrix cyclic group
    
    
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    cin.ignore();  // needed for next cin with prompt to behave
    
    cout << "seed matrix: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
    
    if(!matqConvFromStr(x, xString))
    {
        cout << "bad input" << endl << endl;
        goto again;
    }
    
    free(xString);
    
    if(!genMatrixCyclicGroup(z, x, p))
    {
        cout << "failed" << endl;
        goto again;
    }
    
    m = x.nr;
    order = pow(p, m) - 1;
    for(i=0;i<order;++i)
        cout << z[i] << endl;
    cout << endl;
    
    goto again;
    
    return 0;
}

